#include "desktop_share_def.h"

#include <string>
#include <vector>
#include <map>

namespace CSFUnified {

class MockDSMgrImpl : public JM_SDK::IDSMgr
{
public:
    MockDSMgrImpl(){
        
    }
    ~MockDSMgrImpl(){
        
    }
    
public:
    /**
     *@brief	set ds event for supporting callback
     *@param pEvent  ds event
     */
    virtual void setDSEvent(IDSEvent* pEvent){
        return;
    }
    
    /**
     *@brief	whether is in ds
     *@return  a bool value,true indicate is in ds false not
     */
    virtual bool isInDS(){
        return false;
    }
    
    /**
     *@brief	whether is in ds sharing
     *@return  a bool value,true indicate is in ds sharing false not
     */
    virtual bool isSharingInDS(){
        return false;
    }
    
    /**
     *@brief	judge whether can start ds currently
     *@param sessionName  ds session name
     *@return  a bool value true indicate can start ds false not
     */
    virtual bool canStartDS(const PString sessionName){
        return false;
    }
    
    /**
     *@brief	judge whether can join ds currently
     *@param sessionName  ds session name
     *@return  a bool value true indicate can join ds false not
     */
    virtual bool canJoinDS(const PString sessionName){
        return false;
    }
    
    /**
     *@brief	start ds
     *@param sessionName  ds session name
     *@param serverUrl  server url info
     *@param token  ds token
     */
    virtual void startDS(const PString sessionName, const PString serverUrl, const PString token){
        
    }
    
    /**
     *@brief	join ds
     *@param sessionName  ds session name
     */
    virtual void joinDS(const PString sessionName){
        
    }
    
    /**
     *@brief	decline ds invitation
     *@param sessionName  ds session name
     */
    virtual void declineDSInvitation(const PString sessionName){
        
    }
    
    /**
     *@brief	invite user into ds
     *@param sessionName  ds session name
     */
    virtual void inviteUser2DS(const PString sessionName){
        
    }
    
    /**
     *@brief	end ds session
     */
    virtual void endDS(){
        
    }
    
    /**
     *@brief	share ds again when already in ds session
     */
    virtual void reSharing(){
        
    }
    
    /**
     *@brief	change ds presenter
     */
    virtual void changePresenter(){
        
    }
    
    /**
     *@brief	receive ds invitation
     *@param sessionName  ds session name
     *@param cmdMsg  the message of ds invitation
     */
    virtual void receiveDSInvitation(const PString sessionName, const PString cmdMsg){
        
    }
    
    /**
     *@brief	receive ds decline
     *@param sessionName  ds session name
     */
    virtual void receiveDSDecline(const PString sessionName){
        
    }
    
    /**
     *@brief	receive ds cancelled
     *@param sessionName  ds session name
     */
    virtual void receiveDSCancelled(const PString sessionName){
        
    }

};
}
